import React, { useEffect } from 'react';
import { Text, View } from 'react-native';
const ChildComponent = (props) => {
    const updateAndMount = () => {
        console.log('ChildComponent: componentDidMount called.');
        console.log('ChildComponent: componentDidUpdate called.');
    }
    const willUnmount = () => {
        console.log('ChildComponent: componentWillUnmount called.');
    }
    useEffect(
        () => {
            updateAndMount();
            return () => willUnmount();
        });

    return (
        <View style={{ justifyContent: 'center', alignItems: 'center' }}>
            <Text style={{ fontSize: 20 }}>Language is: {props.name}</Text>
        </View>
    );

}
export default ChildComponent;